package w83b.w83bOperacionesPaso.w83bListados.w83bActas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


import w83b.w83bBeans.W83bListadosBean;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaTerritorioOtraDireccionExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String strRutaExcel;
        List listaTerritorio = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoTerritoriosBean = (W83bListadosBean)contexto.get("w83bListadosBean");                         
        
        strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bLisTerritorioOtraDirActas.xls";                         
        
        InputStream inputStream = W83bTablaTerritorioOtraDireccionExcelAction.class.getResourceAsStream(strRutaExcel);                         
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);                         
		W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                         
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja                         
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja                         

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                         
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                               
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                         
           
        HashMap mapaTerritorios=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                         
        
        HSSFRow row = sheet.getRow((short)4);                         
        HSSFCell cell = row.getCell((short)2);                         
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaTerritorios.get("tituloDepEs");                         
        StringBuffer tituloImagenEu =  (StringBuffer)mapaTerritorios.get("tituloDepEu");                         
        cell.setCellValue(tituloImagenEu.toString());                         
        
        cell = row.getCell((short)5);                         
        cell.setCellValue(tituloImagenEs.toString());                         
        
        tituloImagenEs = (StringBuffer)mapaTerritorios.get("tituloDelelegacionEs");                         
        tituloImagenEu = (StringBuffer)mapaTerritorios.get("tituloDelelegacionEu");                         
        
        row = sheet.getRow((short)6);                         
        cell = row.getCell((short)2);                         
        cell.setCellValue(tituloImagenEu.toString());                         
        
        cell = row.getCell((short)5);                         
        cell.setCellValue(tituloImagenEs.toString());                         
        
        
        row = sheet.getRow((short)9);                         
        cell = row.getCell((short)0);                         
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.listados.listadosTerritorioOtro").toUpperCase());                         
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)12);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.territorio"));
        cell = row.createCell((short)2); 
        cell.setCellValue(listadoTerritoriosBean.getDescTerritorio().toUpperCase());
        cell.setCellStyle(excel.styleTexto9);
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(12,Short.parseShort("2"),12,Short.parseShort("3")));//NOPMD
	 		cell = row.createCell((short)3); 
	        cell.setCellStyle(excel.styleTexto9);
		}
        
        
        row = sheet.getRow((short)W83bClsConstantes.QUINCE);
        cell = row.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.numeroActa"));
        
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.listados.codCentroActas"));
        
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.listados.provCentroActas"));
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        
        for(int i=0;i<listaTerritorio.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISEIS+i); // Creacin de la fila 1
        	
        	cell = row.createCell((short)0);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("0"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("1")));//NOPMD
        	StringBuffer numActa = new StringBuffer();//NOPMD
        	numActa.append(((W83bListadosBean)listaTerritorio.get(i)).getTerritorio()).append("/").append(((W83bListadosBean)listaTerritorio.get(i)).getAnyoActa()).append("/");
        	String valor=W83bUtilidadesComunes.rellenarCeros(((W83bListadosBean)listaTerritorio.get(i)).getNumActa());
        	numActa.append(valor);
        	if(StringUtils.isNotEmpty(numActa.toString())){
        		cell.setCellValue(numActa.toString());
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)1);
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell((short)2);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("2"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("5")));//NOPMD
        	
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaTerritorio.get(i)).getCif()) && StringUtils.isNotEmpty(((W83bListadosBean)listaTerritorio.get(i)).getNumCentro())){
        		cell.setCellValue(((W83bListadosBean)listaTerritorio.get(i)).getCif().toUpperCase()+"/"+((W83bListadosBean)listaTerritorio.get(i)).getNumCentro());
        	}
        	
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)3);
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)4);
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)5);
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell((short)6);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("6"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("9")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaTerritorio.get(i)).getDescTerritorio())){
        		cell.setCellValue(((W83bListadosBean)listaTerritorio.get(i)).getDescTerritorio().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)7);
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)8);
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)9);
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoTerritorioOtraDireccion.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}

	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
}
